<?php

namespace App\Modules\GroupProvider\Application\ListGallery;

use App\Modules\GroupProvider\Domain\GroupProviderRepository;
use App\Modules\GroupProvider\Domain\ListGalleryGroupProvider;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Domain\QueryList\QueryPaginate;

final class GalleryGroupProviderLister
{
    public function __construct(private GroupProviderRepository $repository)
    {
    }

    public function __invoke(
        DateStart $dateStart,
        DateEnd $dateEnd,
        string $search,
        string $action,
        QueryPaginate $queryPaginate,
    ) {
        return $this->repository->search(new ListGalleryGroupProvider(
            $dateStart,
            $dateEnd,
            $search,
            $action,
            $queryPaginate
        ));
    }
}
