<?php

namespace App\Modules\GroupProvider\Application\Index;

use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\GroupProvider\Domain\GroupProviderRepository;
use App\Modules\GroupProvider\Domain\IndexGroupProvider;

final class GroupProviderIndexer
{
    public function __construct(private GroupProviderRepository $repository)
    {
    }

    public function __invoke(IdGroupProvider $id)
    {
        return $this->repository->find(new IndexGroupProvider($id));
    }
}
