<?php

namespace App\Modules\GroupPassengerMedia\Infrastructure;

use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMedia;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaRepository;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\DBRequester;

class MysqlGroupPassengerMediaRepository implements GroupPassengerMediaRepository
{

    public function find(StorageCriteria $criteria): GroupPassengerMedia | null
    {
        $data = $criteria->run();
        if ($data === null) {
            return null;
        }
        return GroupPassengerMedia::fromDTO($criteria->run());
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn ($btp) => GroupPassengerMedia::fromDTO($btp), $criteria->run());
    }

    public function insert(GroupPassengerMedia $value)
    {
        return DBRequester::requestInsert($value);
    }

    public function update(GroupPassengerMedia $value)
    {
        return DBRequester::requestUpdate($value);
    }
}
