<?php

namespace App\Modules\GroupPassengerMedia\Application\Index;

use App\Modules\GroupPassengerMedia\Domain\IdGroupPassengerMedia;
use App\Modules\GroupPassengerMedia\Domain\GroupPassengerMediaRepository;
use App\Modules\GroupPassengerMedia\Domain\IndexGroupPassengerMedia;

final class GroupPassengerMediaIndexer
{
    public function __construct(private GroupPassengerMediaRepository $repository)
    {
    }

    public function __invoke(IdGroupPassengerMedia $idGroupPassengerMedia, bool $lockInShare = false)
    {
        $index = $this->repository->find(new IndexGroupPassengerMedia($idGroupPassengerMedia, $lockInShare));
        return $index;
    }
}
