<?php

namespace App\Modules\GroupPassenger\Infraestructure;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\GroupPassenger\Domain\GroupPassenger;
use App\Modules\GroupPassenger\Domain\GroupPassengerExternalReview;
use App\Modules\GroupPassenger\Domain\GroupPassengerIdAlter;
use App\Modules\GroupPassenger\Domain\GroupPassengerModel;
use App\Modules\GroupPassenger\Domain\GroupPassengerNotification;
use App\Modules\GroupPassenger\Domain\GroupPassengerNotificationAccepted;
use App\Modules\GroupPassenger\Domain\GroupPassengerRepository;
use App\Modules\GroupPassenger\Domain\GroupPassengerReviewDateUpdate;
use App\Modules\GroupPassenger\Domain\GroupPassengerReviewStatus;
use App\Modules\GroupPassenger\Domain\GroupPassengerType;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\DBRequester;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlGroupPassengerRepository implements GroupPassengerRepository
{

    public function find(StorageCriteria $criteria): GroupPassengerModel | null
    {
        $data = $criteria->run();
        if ($data === null) {
            return null;
        }
        return GroupPassengerModel::fromDTO($criteria->run());
    }

    public function index(
        IdGroupPassenger $id
    ): GroupPassenger {
        $response = Requester::requestSelect(
            'CALL sp_group_passenger_index_alter(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
        return new GroupPassenger(
            new IdGroupPassenger($response['Response_Data'][0]->Id_GroupPassenger),
            new GroupPassengerType($response['Response_Data'][0]->GroupPassenger_Type),
            new GroupPassengerNotification($response['Response_Data'][0]->GroupPassenger_Notification),
            new GroupPassengerNotificationAccepted($response['Response_Data'][0]->GroupPassenger_NotificationAccepted),
            new GroupPassengerExternalReview($response['Response_Data'][0]->GroupPassenger_ExternalReview),
            new GroupPassengerReviewStatus($response['Response_Data'][0]->GroupPassenger_ReviewStatus),
            new GroupPassengerReviewDateUpdate($response['Response_Data'][0]->GroupPassenger_ReviewDateUpdate),
            new IdGroup($response['Response_Data'][0]->Id_Group),
            new GroupPassengerIdAlter($response['Response_Data'][0]->Id),
        );
    }

    public function update(
        GroupPassenger $model
    ) {
        return Requester::requestUpdate(
            'CALL sp_group_passenger_update_alter(?,?,?,?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $model->id()->value(),
                $model->type()->value(),
                $model->notification()->value(),
                $model->notificationAccepted()->value(),
                $model->externalReview()->value(),
                $model->reviewStatus()->value(),
                $model->reviewDateUpdate()->value(),
                $model->idGroup()->value(),
                $model->idAlter()->value(),
            ]
        );
    }

    public function findWithReview(IdGroup $idGroup, $path, $pathCountry): array
    {
        return Requester::requestSelect(
            'CALL sp_group_passenger_list_with_review(?,?,?,@sts,@cod,@msg)',
            [
                $idGroup->getValue(),
                $pathCountry,
                $path
            ]
        );
    }

    public function search(StorageCriteria $criteria): array
    {
        return $criteria->run();
    }

    public function updateModel(GroupPassengerModel $value)
    {
        return DBRequester::requestUpdate($value);
    }
}
