<?php

namespace App\Modules\GroupPassenger\Domain;

use App\Modules\Shared\Domain\ErrorDictionary;
use App\Modules\Shared\Exceptions\BasicRequestException;

class GroupPassengerNotFound extends BasicRequestException
{
    public function __construct()
    {
        parent::__construct(
            404,
            ErrorDictionary::ERRORS['OWNER']['GROUP_PASSENGER']['GROUP_PASSENGER_FIND']['GROUP_PASSENGER_NOT_FOUND'],
            'Pasajero de grupo no encontrado'
        );
    }
}
