<?php

namespace App\Modules\GroupPassenger\Application\Update;

use App\Modules\GroupPassenger\Domain\GroupPassenger;
use App\Modules\GroupPassenger\Domain\GroupPassengerRepository;

final class GroupPassengerUpdater
{
    public function __construct(private GroupPassengerRepository $repository)
    {
    }

    public function __invoke(GroupPassenger $groupPassenger): UpdateGroupPassengerResponse
    {
        return new UpdateGroupPassengerResponse($this->repository->update($groupPassenger));
    }
}
