<?php

namespace App\Modules\GroupPassenger\Application\List;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\GroupPassenger\Domain\GroupPassengerRepository;
use App\Modules\GroupPassenger\Domain\ListGroupPassenger;

class GroupPassengerLister
{

    private GroupPassengerRepository $repository;

    public function __construct(GroupPassengerRepository $repository)
    {
        $this->repository = $repository;
    }

    public function __invoke(IdGroup $id)
    {
        return $this->repository->search(new ListGroupPassenger($id));
    }
}
