<?php

namespace App\Modules\Group\Infraestructure;

use App\Modules\Group\Domain\IncludeSelf;
use App\Modules\Group\Domain\GroupSlaveRepository;
use App\Modules\Group\Domain\IdGroup;
use Illuminate\Support\Facades\DB;

class MysqlGroupSlaveRepository implements GroupSlaveRepository
{

    public function list(IdGroup $idGroup, IncludeSelf $includeSelf)
    {
        return DB::select(
            'call sp_group_slave_list(?,?)',
            [
                $idGroup->getValue(),
                $includeSelf->value(),
            ]
        );
    }
}
