<?php

namespace App\Modules\Group\Infraestructure;

use App\Modules\Group\Domain\GroupDateEnd;
use App\Modules\Group\Domain\GroupDateStart;
use App\Modules\Group\Domain\GroupReviewListRepository;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlGroupReviewListRepository implements GroupReviewListRepository
{
    public function __invoke(GroupDateStart $dateStart, GroupDateEnd $dateEnd)
    {
        return Requester::requestSelect(
            'CALL sp_group_review_list(?,?,@sts,@cod,@msg)',
            [
                $dateStart->value(),
                $dateEnd->value()
            ]
        );
    }
}
