<?php

namespace App\Modules\Group\Infraestructure;

use App\Modules\Group\Domain\GroupFindByTokenRepository;
use App\Modules\Group\Domain\GroupToken;
use App\Modules\Shared\Application\ActionHandler;
use Illuminate\Support\Facades\DB;

class MysqlGroupFindByTokenRepository implements GroupFindByTokenRepository
{

    public function __invoke(GroupToken $groupToken)
    {
        return (new ActionHandler())->handle(DB::select(
            'call sp_group_find_by_token(?)',
            [
                $groupToken->getValue()
            ]
        ));
    }
}
