<?php

namespace App\Modules\Group\Application\UpdateDateUpdate;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateGroupDateUpdateQueryHandler implements QueryHandler
{
    public function __construct(private GroupUpdateDateUpdater $updater)
    {
    }

    public function __invoke(UpdateGroupDateUpdateQuery $query): UpdateGroupDateUpdateQueryResponse
    {
        return $this->updater->__invoke(new IdGroup($query->idGroup()));
    }
}
