<?php

namespace App\Modules\Group\Application\ListGroupProgramming;

use App\Modules\CategoryTour\Domain\IdCategoryTour;
use App\Modules\Group\Domain\GroupRepositoryAlter;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Tour\Domain\IdTour;

final class GroupProgrammingLister
{
    public function __construct(
        private GroupRepositoryAlter $repository,
        private QueryBus $bus
    ) {
    }

    public function __invoke(
        string $action,
        IdCategoryTour $idCategoryTour,
        IdTour $idTour,
        DateStart $dateStart,
        DateEnd $dateEnd,
        string $token
    ): ListGroupProgrammingResponses {
        $list = $this->repository->list(
            $action,
            $idCategoryTour,
            $idTour,
            $dateStart,
            $dateEnd,
            $token
        );
        return new ListGroupProgrammingResponses(...array_map(fn ($ele) => $this->convertToResponse($ele), $list));
    }

    private function convertToResponse($element): ListGroupProgrammingResponse
    {
        return new ListGroupProgrammingResponse(
            $element->Id_Tour,
            $element->Tour_Code,
            $element->Tour_Name,
            $element->Tour_Color,
            $element->BookingTour_DateStart,
            $element->Passenger_Amount,
            $element->Package_Name,
            $element->Package_Code,
            json_decode($element->Passenger_List),
            json_decode($element->Group_Providers),
            $element->Id_Group,
            $element->Group_Name,
            $element->Group_DateStart,
            $element->Group_DateEnd,
            $element->Group_Type,
            $element->Group_TourDuration,
            $element->Group_Remark,
            $element->Group_MasterType,
            $element->Group_ServiceType,
            $element->Group_ValidPassengers,
            $element->Group_NoValidPassengers,
            $element->Group_Birthday,
            $element->Group_NotificationCount,
            $element->Group_NotificationStatus,
            $element->Group_Status,
            $element->Id_Master,
            $element->Service_Detail,
            $element->Booking_Code
        );
    }
}
