<?php

namespace App\Modules\Group\Application\CopyProviders;

use App\Modules\CategoryTour\Domain\IdCategoryTour;
use App\Modules\Group\Domain\IdGroup;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Tour\Domain\IdTour;

final class CopyProvidersGroupQueryHandler implements QueryHandler
{
    public function __construct(private GroupProvidersCopier $copier)
    {
    }

    public function __invoke(CopyProvidersGroupQuery $query): CopyProvidersGroupResponse
    {
        return $this->copier->__invoke(new IdGroup($query->idGroup()));
    }
}
