<?php

namespace App\Modules\FactTypeReceipt\Application\List;

use App\Modules\FactTypeReceipt\Application\FactTypeReceiptResponse;
use App\Modules\FactTypeReceipt\Application\FactTypeReceiptResponses;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FactTypeReceiptListerQueryHandler implements QueryHandler
{
    public function __construct(private FactTypeReceiptLister $lister)
    {
    }

    public function __invoke(FactTypeReceiptListerQuery $query): FactTypeReceiptResponses
    {
        return new FactTypeReceiptResponses(...array_map(
            fn ($index) => new FactTypeReceiptResponse(
                $index->id()->value(),
                $index->name()->value(),
                $index->abrv()->value(),
                $index->status()->value(),
            ),
            $this->lister->__invoke($query->getAction())
        ));
    }
}
