<?php

namespace App\Modules\FactTypeDocument\Application\Index;

use App\Modules\FactTypeDocument\Application\FactTypeDocumentResponse;
use App\Modules\FactTypeDocument\Domain\IdFactTypeDocument;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FactTypeDocumentIndexerQueryHandler implements QueryHandler
{
    public function __construct(private FactTypeDocumentIndexer $inserter)
    {
    }

    public function __invoke(FactTypeDocumentIndexerQuery $query): FactTypeDocumentResponse
    {
        $model = $this->inserter->__invoke(new IdFactTypeDocument($query->getId()));
        return new FactTypeDocumentResponse(
            $model->id()->value(),
            $model->name()->value(),
            $model->abrv()->value(),
            $model->status()->value(),
        );
    }
}
