<?php

namespace App\Modules\FactReceiptDetail\Domain;

use App\Modules\FactProduct\Domain\FactProduct;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexFactReceiptDetail implements StorageCriteria
{

    public function __construct(
        private IdFactReceiptDetail $id
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = FactReceiptDetail::select('`ftd`');
        $selectProduct = FactProduct::select('`fp`');
        return DB::select(
            "SELECT $select, $selectProduct
            FROM `t_fact_receipt_detail` `ftd`
            INNER JOIN `t_fact_product` `fp` ON `ftd`.`Id_FactProduct` = `fp`.`Id_FactProduct`
            WHERE `ftd`.`Id_FactReceiptDetail` = ?",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new FactReceiptDetailNotFound();
        }
        return $data[0];
    }
}
