<?php

namespace App\Modules\FactReceiptDetail\Application\Update;

use App\Modules\FactReceiptDetail\Application\Update\FactReceiptDetailUpdaterResponse;
use App\Modules\FactReceiptDetail\Domain\FactReceiptDetail;
use App\Modules\FactReceiptDetail\Domain\FactReceiptDetailRepository;
use App\Modules\FactReceiptDetail\Domain\UpdateFactReceiptDetail;

final class FactReceiptDetailUpdater
{
    public function __construct(private FactReceiptDetailRepository $repository)
    {
    }

    public function __invoke(UpdateFactReceiptDetail $lead): FactReceiptDetailUpdaterResponse
    {
        return new FactReceiptDetailUpdaterResponse($this->repository->update($lead));
    }
}
