<?php

namespace App\Modules\FactReceiptDetail\Application\Index;

use App\Modules\FactReceiptDetail\Application\FactReceiptDetailResponse;
use App\Modules\FactReceiptDetail\Domain\IdFactReceiptDetail;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FactReceiptDetailIndexerQueryHandler implements QueryHandler
{
    public function __construct(private FactReceiptDetailIndexer $inserter)
    {
    }

    public function __invoke(FactReceiptDetailIndexerQuery $query): FactReceiptDetailResponse
    {
        $model = $this->inserter->__invoke(new IdFactReceiptDetail($query->getId()));
        return new FactReceiptDetailResponse(
            $model->id()->value(),
            $model->amount()->value(),
            $model->unitPrice()->value(),
            $model->discount()->value(),
            $model->total()->value(),
            $model->status()->value(),
            (object)[
                'Id_FactProduct' => $model->idFactProduct()->id()->value(),
                'FactProduct_Code' => $model->idFactProduct()->code()->value(),
                'FactProduct_Name' => $model->idFactProduct()->name()->value(),
                'FactProduct_IdProduct' => $model->idFactProduct()->idProduct()->value(),
                'FactProduct_Status' => $model->idFactProduct()->status()->value(),
            ],
            $model->idFactTypeOperation()->value(),
            $model->idFactUnit()->value(),
            $model->idFactReceipt()->value(),
        );
    }
}
