<?php

namespace App\Modules\FactReceiptDetail\Application\Delete;

use App\Modules\FactReceipt\Domain\IdFactReceipt;
use App\Modules\FactReceiptDetail\Domain\IdFactReceiptDetail;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteFactReceiptDetailQueryHandler implements QueryHandler
{
    public function __construct(
        private FactReceiptDetailDeleter $deleter
    ) {
    }

    public function __invoke(DeleteFactReceiptDetailQuery $query): DeleteFactReceiptDetailResponse
    {
        return new DeleteFactReceiptDetailResponse($this->deleter->__invoke(new IdFactReceiptDetail($query->id())));
    }
}
