<?php

namespace App\Modules\FactReceipt\Infraestructure;

class FactReceiptValidators
{

    public const SEND = [];

    public const INSERT = [
        'FactReceipt_NoDocument'    => 'required|string|max:250',
        'FactReceipt_BusinessName'  => 'required|string|max:250',
        'FactReceipt_Email'         => 'required|string|email|max:250',
        'FactReceipt_Address'       => 'required|string|max:500',
        'FactReceipt_LicensePlate'  => 'required|string|max:250',
        'FactReceipt_Currency'      => 'required|string|max:10',
        'Id_FactTypeReceipt'        => 'required|int',
        'Id_FactTypeDocument'       => 'required|int',
        'Id_FactPaymentMethod'      => 'required|int',
        'Id_FactCurrency'           => 'required|int',
    ];

    public const UPDATE = [
        'Id_FactReceipt'            => 'required|int',
        'FactReceipt_DateEmission'  => 'required|string|string',
        'FactReceipt_NoDocument'    => 'required|string|max:250',
        'FactReceipt_BusinessName'  => 'required|string|max:250',
        'FactReceipt_Email'         => 'required|string|email|max:250',
        'FactReceipt_Address'       => 'required|string|max:500',
        'FactReceipt_LicensePlate'  => 'string|max:250',
        'FactReceipt_Currency'      => 'required|string|max:10',
        'Id_FactTypeReceipt'        => 'required|int',
        'Id_FactTypeDocument'       => 'required|int',
        'Id_FactPaymentMethod'      => 'required|int',
        'Id_FactCurrency'           => 'required|int',
    ];
}
