<?php

namespace App\Modules\FactReceipt\Domain;

use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class UpdateStatusFactReceipt extends AggregateRoot
{

  /** @return AgregateAttribute[] */
  protected static function attributes(): array
  {
    return [
      new AggregateAttribute('id', IdFactReceipt::class, 'Id_FactReceipt'),
      new AggregateAttribute('responseMessage', FactReceiptResponseMessage::class, 'FactReceipt_ResponseMessage'),
      new AggregateAttribute('status', FactReceiptStatus::class, 'FactReceipt_Status'),
    ];
  }

  public function __construct(
    private IdFactReceipt $id,
    private FactReceiptResponseMessage $responseMessage,
    private FactReceiptStatus $status,
  ) {
  }

  public function id(): IdFactReceipt
  {
    return $this->id;
  }

  public function responseMessage(): FactReceiptResponseMessage
  {
    return $this->responseMessage;
  }

  public function status(): FactReceiptStatus
  {
    return $this->status;
  }
}
