<?php

namespace App\Modules\FactReceipt\Application\UpdateStatus;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class UpdateStatusFactReceiptQuery implements Query
{
    public function __construct(
        private int $id,
        private string $responseMessage,
        private int $status,
    ) {
    }

    public function id(): int
    {
        return $this->id;
    }

    public function responseMessage(): string
    {
        return $this->responseMessage;
    }

    public function status(): int
    {
        return $this->status;
    }
}
