<?php

namespace App\Modules\FactReceipt\Application\Update;

use App\Modules\FactCurrency\Domain\IdFactCurrency;
use App\Modules\FactPaymentMethod\Domain\IdFactPaymentMethod;
use App\Modules\FactReceipt\Application\Index\FactReceiptIndexer;
use App\Modules\FactReceipt\Domain\IdFactReceipt;
use App\Modules\FactReceipt\Domain\FactReceipt;
use App\Modules\FactReceipt\Domain\FactReceiptAddress;
use App\Modules\FactReceipt\Domain\FactReceiptBusinessName;
use App\Modules\FactReceipt\Domain\FactReceiptCurrency;
use App\Modules\FactReceipt\Domain\FactReceiptDate;
use App\Modules\FactReceipt\Domain\FactReceiptDateEmission;
use App\Modules\FactReceipt\Domain\FactReceiptDateUpdate;
use App\Modules\FactReceipt\Domain\FactReceiptEmail;
use App\Modules\FactReceipt\Domain\FactReceiptLicensePlate;
use App\Modules\FactReceipt\Domain\FactReceiptNoDocument;
use App\Modules\FactReceipt\Domain\FactReceiptResponseMessage;
use App\Modules\FactReceipt\Domain\FactReceiptStatus;
use App\Modules\FactReceipt\Domain\UpdateFactReceipt;
use App\Modules\FactTypeDocument\Domain\IdFactTypeDocument;
use App\Modules\FactTypeReceipt\Domain\IdFactTypeReceipt;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FactReceiptUpdaterQueryHandler implements QueryHandler
{
    public function __construct(
        private FactReceiptUpdater $updater,
        private FactReceiptIndexer $indexer
    ) {
    }

    public function __invoke(FactReceiptUpdaterQuery $query): FactReceiptUpdaterResponse
    {
        $model = new UpdateFactReceipt(
            new IdFactReceipt($query->id()),
            new FactReceiptDateEmission($query->dateEmission()),
            new FactReceiptNoDocument($query->noDocument()),
            new FactReceiptBusinessName($query->businessName()),
            new FactReceiptEmail($query->email()),
            new FactReceiptAddress($query->address()),
            new FactReceiptLicensePlate($query->licensePlate()),
            new FactReceiptCurrency($query->currency()),
            new IdFactTypeReceipt($query->idFactTypeReceipt()),
            new IdFactTypeDocument($query->idFactTypeDocument()),
            new IdFactPaymentMethod($query->idFactPaymentMethod()),
            new IdFactCurrency($query->idFactCurrency()),
        );
        return $this->updater->__invoke($model);
    }
}
