<?php

namespace App\Modules\FactReceipt\Application\List;

use App\Modules\FactReceipt\Application\FactReceiptResponse;
use App\Modules\FactReceipt\Application\FactReceiptResponses;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class FactReceiptListerQueryHandler implements QueryHandler
{
    public function __construct(private FactReceiptLister $lister)
    {
    }

    public function __invoke(FactReceiptListerQuery $query): FactReceiptResponses
    {
        return new FactReceiptResponses(...array_map(
            fn ($index) => new FactReceiptResponse(
                $index->id()->value(),
                $index->date()->value(),
                $index->dateUpdate()->value(),
                $index->dateEmission()->value(),
                $index->noDocument()->value(),
                $index->businessName()->value(),
                $index->email()->value(),
                $index->address()->value(),
                $index->licensePlate()->value(),
                $index->currency()->value(),
                $index->responseMessage()->value(),
                $index->status()->value(),
                $index->idFactTypeReceipt()->value(),
                $index->idFactTypeDocument()->value(),
                $index->idFactPaymentMethod()->value(),
                $index->idFactCurrency()->value(),
            ),
            $this->lister->__invoke($query->getAction())
        ));
    }
}
