<?php

namespace App\Modules\FactProduct\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexFactProduct implements StorageCriteria
{

    public function __construct(
        private IdFactProduct $id
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = FactProduct::select('`ftd`');
        return DB::select(
            "SELECT $select
            FROM `t_fact_product` `ftd`
            WHERE `ftd`.`Id_FactProduct` = ?",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new FactProductNotFound();
        }
        return $data[0];
    }
}
