<?php

namespace App\Modules\FactCurrency\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class UpdateFactCurrencyQuery implements Query
{
    public function __construct(
        private int $id,
        private string $name,
        private string $abrv,
        private int $status,
    ) {
    }

    public function id(): int
    {
        return $this->id;
    }

    public function name(): string
    {
        return $this->name;
    }

    public function abrv(): string
    {
        return $this->abrv;
    }

    public function status(): int
    {
        return $this->status;
    }
}
