<?php

namespace App\Modules\ExternalApiRequest\Infrastructure;

use App\Modules\ExternalApiRequest\Domain\ExternalApiRequest;
use App\Modules\ExternalApiRequest\Domain\ExternalApiRequestRepository;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\DBRequester;

class MysqlExternalApiRequestRepository implements ExternalApiRequestRepository
{

    public function find(StorageCriteria $criteria): ExternalApiRequest | null
    {
        $data = $criteria->run();
        if ($data === null) {
            return null;
        }
        return ExternalApiRequest::fromDTO($data);
    }

    public function insert(ExternalApiRequest $value)
    {
        return DBRequester::requestInsert($value);
    }

    public function update(ExternalApiRequest $value)
    {
        return DBRequester::requestUpdate($value);
    }
}
