<?php

namespace App\Modules\ExternalApiRequest\Application\Update;

use App\Modules\ExternalApiRequest\Application\Index\ExternalApiRequestIndexer;
use App\Modules\ExternalApiRequest\Domain\IdExternalApiRequest;
use App\Modules\ExternalApiRequest\Domain\ExternalApiRequestResponse;
use App\Modules\ExternalApiRequest\Domain\ExternalApiRequestStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateExternalApiRequestQueryHandler implements QueryHandler
{
    public function __construct(
        private ExternalApiRequestUpdater $updater,
        private ExternalApiRequestIndexer $indexer
    ) {
    }

    public function __invoke(UpdateExternalApiRequestQuery $query): UpdateExternalApiRequestResponse
    {
        $index = $this->indexer->__invoke(new IdExternalApiRequest($query->id()), true);
        $index->setResponse(new ExternalApiRequestResponse($query->response()));
        $index->setStatus(new ExternalApiRequestStatus($query->status()));
        $this->updater->__invoke($index);
        return new UpdateExternalApiRequestResponse();
    }
}
