<?php

namespace App\Modules\CashMovementFactReceipt\Infraestructure;

use App\Modules\CashMovementFactReceipt\Domain\CashMovementFactReceipt;
use App\Modules\CashMovementFactReceipt\Domain\CashMovementFactReceiptRepository;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlCashMovementFactReceiptRepository implements CashMovementFactReceiptRepository
{

    public function find(StorageCriteria $criteria): CashMovementFactReceipt | null
    {
        $data = $criteria->run();
        if ($data === null) {
            return null;
        }
        return CashMovementFactReceipt::fromDTO($criteria->run());
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn($btp) => CashMovementFactReceipt::fromDTO($btp), $criteria->run());
    }

    public function insert(CashMovementFactReceipt $value)
    {
        return Requester::requestInsert(
            'CALL sp_cash_movement_fact_receipt_insert(?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->status()->value(),
                $value->idCashMovement()->value(),
                $value->idFactReceipt()->value(),
            ]
        );
    }

    public function update(CashMovementFactReceipt $value)
    {
        return Requester::requestUpdate(
            'CALL sp_cash_movement_fact_receipt_update(?,?,?,?,@sts,@cod,@msg)',
            [
                $value->id()->value(),
                $value->status()->value(),
                $value->idCashMovement()->value(),
                $value->idFactReceipt()->value(),
            ]
        );
    }
}
