<?php

namespace App\Modules\CashMovementFactReceipt\Domain;

use App\Modules\FactReceipt\Domain\FactReceipt;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexCashMovementFactReceipt implements StorageCriteria
{

    public function __construct(
        private IdCashMovementFactReceipt $id
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = CashMovementFactReceipt::select('`cmfr`');

        return DB::select(
            "SELECT $select
            FROM `t_cash_movement_fact_receipt` `cmfr`
            WHERE `cmfr`.`Id_CashMovementFactReceipt` = ?",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new CashMovementFactReceiptNotFound();
        }
        return $data[0];
    }
}
