<?php

namespace App\Modules\CashMovementDetail\Infrastructure;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\CashMovementDetail\Domain\CashMovementDetailRepository;
use App\Modules\Shared\Infraestructure\Format1Requester;

class MysqlCashMovementDetailRepository implements CashMovementDetailRepository
{
    public function list(IdCashMovement $idCashMovement, string $action)
    {
        return Format1Requester::request(
            'CALL sp_cash_movement_detail_list(?,?)',
            [
                $idCashMovement->value(),
                $action
            ]
        );
    }

    public function listForFacture(IdCashMovement $idCashMovement, string $action)
    {
        return Format1Requester::request(
            'CALL sp_cash_movement_detail_list_for_facture(?,?,@sts,@cod,@msg)',
            [
                $idCashMovement->value(),
                $action
            ]
        );
    }
}