<?php

namespace App\Modules\CashMovement\Infraestructure;

class CashMovementValidators
{

    public const UPDATE_CYCLE_TYPE = [
        'Id_CashMovement'               => 'required|int',
        'CashMovement_CycleType'        => 'required|int'
    ];

    public const FIRST_INSERT = [
        'CashMovement_DatePayment'      => 'required|string',
        'CashMovement_Amount'           => 'required|numeric',
        'CashMovement_Currency'         => 'required|string|max:4',
        'CashMovement_Name'             => 'required|string|max:100',
        'CashMovement_LastName'         => 'string|max:100',
        'CashMovement_Email'            => 'string|max:250',
        'CashMovement_Country'          => 'string|max:100',
        'CashMovement_City'             => 'string|max:100',
        'CashMovement_Address'          => 'string|max:250',
        'CashMovement_Phone'            => 'string|max:50',
        'CashMovement_CardLast'         => 'required|string|max:10',
        'CashMovement_CardBrand'        => 'required|string|max:50',
        'CashMovement_CardType'         => 'required|string|max:50',
        'CashMovement_CardIssuer'       => 'required|string|max:50',
        'CashMovement_Remark'           => 'string',
        'Id_TypePayment'                => 'required|int',
        'Invoices'                      => 'required|string',
        'Require_Gateway'               => 'required|int'
    ];

    public const CASH_INSERT = [
        'CashMovement_ReceiptNumber'    => 'required|string|max:100',
    ];

    public const BASIC_INSERT = [
        'CashMovement_ReceiptNumber'    => 'required|string|max:100',
    ];

    public const CARD_INSERT = [
        // 'CashMovement_ReceiptNumber' => 'string|max:100',
        'CashMovement_CardNumber'       => 'required|string|max:20',
    ];

    public const FIRST_INSERT_REFUND = [
        'CashMovement_DatePayment'      => 'required|string',
        'CashMovement_Amount'           => 'required|numeric',
        'CashMovement_Currency'         => 'required|string|max:4',
        'CashMovement_Remark'           => 'string',
        'CashMovement_Remark'           => 'string',
        'Id_TypePayment'                => 'required|int',
        'Invoices'                      => 'required|string'
    ];

    public const CASH_INSERT_REFUND = [
        'CashMovement_ReceiptNumber'    => 'required|string|max:100',
    ];

    public const BASIC_INSERT_REFUND = [
        'CashMovement_ReceiptNumber'    => 'required|string|max:100',
    ];

    public const CARD_INSERT_REFUND = [
        'CashMovement_CardNumber'       => 'required|string|max:20',
    ];
}
