<?php

namespace App\Modules\CashMovement\Domain;

use ArrayAccess;
use ArrayIterator;
use Countable;
use IteratorAggregate;
use TypeError;

class InvoiceDataCollection implements Countable, ArrayAccess, IteratorAggregate {

    private array $data;

    public function __construct(InvoiceData ...$data) {
        $this->data = $data;
    }

    public function count(): int {
        return count($this->data);
    }

    public function getIterator(): ArrayIterator {
        return new ArrayIterator($this->data);
    }
 
    public function offsetExists(mixed $offset): bool {
        return isset($this->data[$offset]);
    }
 
    public function offsetGet(mixed $offset): InvoiceData {
        return $this->data[$offset];
    }
 
    public function offsetSet(mixed $offset, mixed $value) : void {
        if ($value instanceof InvoiceData) {
            $this->data[$offset] = $value;
        }
        else throw new TypeError("Invalid value type");
    }
 
    public function offsetUnset(mixed $offset) : void {
        unset($this->data[$offset]);
    }

}