<?php

namespace App\Modules\CashMovement\Application\Index;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexCashMovementQueryHandler implements QueryHandler
{
    public function __construct(private CashMovementIndexer $inserter)
    {
    }

    public function __invoke(IndexCashMovementQuery $query): IndexCashMovementResponse
    {
        return $this->inserter->__invoke(new IdCashMovement($query->id()));
    }
}
