<?php

namespace App\Modules\CashMovement\Application\Delete;

use App\Modules\CashMovement\Domain\IdCashMovement;
use App\Modules\CashMovement\Domain\CashMovementRepository;

final class CashMovementDeleter
{
    public function __construct(private CashMovementRepository $repository)
    {
    }

    public function __invoke(IdCashMovement $idCashMovement): DeleteCashMovementResponse
    {
        return new DeleteCashMovementResponse($this->repository->delete($idCashMovement));
    }
}
