<?php

namespace App\Modules\CashMovement\Application\CreateFactReceipt;

use App\Modules\FactReceipt\Domain\FactReceiptRepository;
use App\Modules\FactReceipt\Domain\InsertFactReceipt;

final class CashMovementFactReceiptCreator
{
    public function __construct(
        private FactReceiptRepository $repository
    ) {
    }

    public function __invoke(InsertFactReceipt $factReceipt): CreateFactReceiptCashMovementResponse
    {
        return new CreateFactReceiptCashMovementResponse($this->repository->createWithCashMovement($factReceipt));
    }
}
