<?php

namespace App\Modules\Briefing\Application\ListGroupPassenger;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class ListGroupPassengerBriefingQuery implements Query
{
    public function __construct(
        private string $dateTimeStart,
        private string $dateTimeEnd,
        private string $type,
        private string $orderBy,
        private int $idGroup,
        private string $dateBriefing
    ) {
    }

    public function dateTimeStart()
    {
        return $this->dateTimeStart;
    }

    public function dateTimeEnd()
    {
        return $this->dateTimeEnd;
    }

    public function type()
    {
        return $this->type;
    }

    public function orderBy()
    {
        return $this->orderBy;
    }

    public function idGroup()
    {
        return $this->idGroup;
    }

    public function dateBriefing()
    {
        return $this->dateBriefing;
    }
}
