<?php

namespace App\Modules\Briefing\Application\List;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\Briefing\Domain\BriefingOrderBy;
use App\Modules\Briefing\Domain\BriefingType;
use App\Modules\Briefing\Domain\ListBriefingModel;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\DateTimeEnd;
use App\Modules\Shared\Domain\DateTimeStart;

final class ListBriefingQueryHandler implements QueryHandler
{
    public function __construct(private BriefingLister $lister)
    {
    }

    public function __invoke(ListBriefingQuery $query): ListBriefingResponses
    {
        return new ListBriefingResponses(...array_map(
            fn ($index) => new ListBriefingResponse(
                $index->Id_BookingTour,
                $index->BookingTour_DateStart,
                $index->BookingTour_PickUp,
                $index->BookingTour_Type,
                $index->BookingTour_NoPax,
                $index->BookingTour_Name,
                $index->BookingTour_TourName,
                $index->BookingTour_FeeType,
                $index->BookingTour_Full,
                $index->BookingTour_MinimumFull,
                $index->BookingTour_Group,
                $index->BookingTour_TourDuration,
                $index->BookingTour_DateBriefing,
                $index->BookingTour_PlaceBriefing,
                $index->BookingTour_UseBookingPlaceBriefing,
                $index->BookingTour_Status,
                $index->Id_Booking,
                $index->Booking_Code,
                $index->Id_Package,
                $index->Package_Code,
                $index->Package_Name,
                $index->Id_Tour,
                $index->Tour_Code,
                $index->Tour_Name,
                $index->Tour_Color,
                $index->Id_Group,
                $index->Group_Name,
                $index->Group_DateStart,
                $index->Group_Remark,
                $index->Passenger_Amount
            ),
            $this->lister->__invoke(
                new DateTimeStart($query->dateTimeStart()),
                new DateTimeEnd($query->dateTimeEnd()),
                new BriefingType($query->type()),
                new BriefingOrderBy($query->orderBy()),
            )
        ));
    }
}
