<?php

namespace App\Modules\BookingUpgradePassenger\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListByIdBookingUpgradePassenger implements StorageCriteria
{

    public function __construct(
        private array $ids
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = BookingUpgradePassenger::select('`bup`');

        $where = $this->whereIn('`bup`.`Id_BookingUpgradePassenger`', $this->ids);

        return DB::select(
            "SELECT $select,
                `p`.`Id_Passenger`,
                `p`.`Passenger_Gender`,
                `p`.`Passenger_Name`,
                `p`.`Passenger_LastName`,

                `bt`.`Id_BookingTour`,
                `bt`.`BookingTour_TourName`,
                `bt`.`BookingTour_DateStart`,
                `bt`.`BookingTour_TourDuration`,

                `b`.`Id_Booking`,
                `b`.`Booking_Code`,
                `b`.`Booking_InternalRemark`,
                `b`.`Booking_Observation`,

                `uc`.`Id_UserCountry`,
                `uc`.`UserCountry_Name`,
                `uc`.`UserCountry_Img`

            FROM `t_booking_upgrade_passenger` `bup`
            INNER JOIN `t_booking_upgrade` `bu` ON `bu`.`Id_BookingUpgrade` = `bup`.`Id_BookingUpgrade`
            INNER JOIN `t_booking_tour` `bt` ON `bt`.`Id_BookingTour` = `bu`.`Id_BookingTour`
            INNER JOIN `t_booking` `b` ON `b`.`Id_Booking` = `bt`.`Id_Booking`
            INNER JOIN `t_booking_tour_passenger` `btp` ON `btp`.`Id_BookingTourPassenger` = `bup`.`Id_BookingTourPassenger`
            INNER JOIN `t_passenger` `p` ON `p`.`Id_Passenger` = `btp`.`Id_Passenger`
            INNER JOIN `t_user_country` `uc` ON `uc`.`Id_UserCountry` = `p`.`Id_UserCountry`
            WHERE $where",
            $this->ids
        );
    }

    private function whereIn($index, $ids)
    {
        return $index . ' IN (' . $this->getQuestionMarks($ids) . ')';
    }

    private function getQuestionMarks($ids)
    {
        return implode(',', array_fill(0, count($ids), '?'));
    }

    protected function analize($data)
    {
        return $data;
    }
}
