<?php

namespace App\Modules\BookingUpgradePassenger\Domain;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;

interface BookingUpgradePassengerRepository
{
    public function index(IdBookingUpgradePassenger $id);
    public function search(StorageCriteria $action): array;
    public function reset(IdBookingUpgradePassenger $id);
    public function mask(IdBookingUpgradePassenger $id, BookingUpgradePassengerMask $mask);
    public function listByPassenger(IdBookingTourPassenger $idBookingTourPassenger);
    public function remove(IdBookingUpgradePassenger $id, int $keepInvoice);
}
