<?php

namespace App\Modules\BookingUpgradePassenger\Domain;

use App\Modules\Admin\Domain\IdAdmin;

class BookingUpgradePassengerFromPassenger
{

    public function __construct(
        private BookingUpgradePassengerDate $date,
        private BookingUpgradePassengerDateEntryStart $dateEntryStart,
        private BookingUpgradePassengerDateEntryEnd $dateDateEntryEnd,
        private BookingUpgradePassengerDatePurchase $dateDatePurchase,
        private BookingUpgradePassengerCode $code,
        private BookingUpgradePassengerAmount $amount,
        private BookingUpgradePassengerRemark $remark,
        private BookingUpgradePassengerStatus $status,
        private IdAdmin $idAdmin,
        private ?IdBookingUpgradePassenger $id = null
    ) {
    }

    public function date(): BookingUpgradePassengerDate
    {
        return $this->date;
    }
    public function dateEntryStart(): BookingUpgradePassengerDateEntryStart
    {
        return $this->dateEntryStart;
    }
    public function dateDateEntryEnd(): BookingUpgradePassengerDateEntryEnd
    {
        return $this->dateDateEntryEnd;
    }
    public function dateDatePurchase(): BookingUpgradePassengerDatePurchase
    {
        return $this->dateDatePurchase;
    }
    public function code(): BookingUpgradePassengerCode
    {
        return $this->code;
    }
    public function amount(): BookingUpgradePassengerAmount
    {
        return $this->amount;
    }
    public function remark(): BookingUpgradePassengerRemark
    {
        return $this->remark;
    }
    public function status(): BookingUpgradePassengerStatus
    {
        return $this->status;
    }
    public function idAdmin(): IdAdmin
    {
        return $this->idAdmin;
    }
    public function id(): IdBookingUpgradePassenger
    {
        return $this->id;
    }
}
