<?php

namespace App\Modules\BookingTourPassenger\Application\UpdatePartial;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class UpdatePartialBookingTourPassengerQuery implements Query
{
    public function __construct(
        private int $id,
        private ?int $hasBeenPrinted = null
    ) {
    }

    public function id(): int
    {
        return $this->id;
    }

    public function hasBeenPrinted(): ?int
    {
        return $this->hasBeenPrinted;
    }
}
