<?php

namespace App\Modules\BookingTourPassenger\Application\Index;

use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerRepository;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;

final class BookingTourPassengerIndexer
{
    public function __construct(
        private BookingTourPassengerRepository $repository
    ) {
    }

    public function __invoke(
        IdBookingTourPassenger $id,
    ): IndexBookingTourPassengerResponse {
        return new IndexBookingTourPassengerResponse($this->repository->index($id));
    }
}
