<?php

namespace App\Modules\BookingTourPassenger\Application\Cancel;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\BookingTourPassenger\Application\Index\BookingTourPassengerIndexer;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CancelBookingTourPassengerQueryHandler implements QueryHandler
{
    public function __construct(
        private BookingTourPassengerCanceller $changer,
        private BookingTourPassengerIndexer $indexer
    ) {
    }

    public function __invoke(CancelBookingTourPassengerQuery $query): CancelBookingTourPassengerResponse
    {
        $index = $this->indexer->__invoke(new IdBookingTourPassenger($query->id()))->response()[0];
        return $this->changer->__invoke(
            new IdBookingTourPassenger($query->id())
        );
    }
}
