<?php

namespace App\Modules\BookingTourPassenger\Application;

use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerReviewRepository;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;

class BookingTourPassengerReviewLister {

    private BookingTourPassengerReviewRepository $repository;

    public function __construct(
        BookingTourPassengerReviewRepository $repository
    ) {
        $this->repository = $repository;
    }

    public function __invoke(IdBookingTourPassenger $id) {
        return $this->repository->getReviews($id);
    }
}