<?php

namespace App\Modules\BookingTourItem\Application\ListExtra;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\BookingTourItem\Application\List\BookingTourItemListerResponse;
use App\Modules\BookingTourItem\Domain\ExtraRepository;

final class ExtraLister
{
    public function __construct(private ExtraRepository $repository)
    {
    }

    public function __invoke(IdBookingTour $idGroupPassenger, string $action): BookingTourItemListerResponse
    {
        return new BookingTourItemListerResponse($this->repository->find($idGroupPassenger, $action));
    }
}
