<?php

namespace App\Modules\BookingTour\Domain;

class BookingTourStatus
{

    public const NULLIFIED = 1;
    public const ACTIVE = 2;

    private int $value;

    public function __construct(int $value)
    {
        $values = [self::NULLIFIED, self::ACTIVE];
        $this->value = in_array($value, $values) ? $value : $values[0];
    }

    public function getValue()
    {
        return $this->value;
    }

    public function value()
    {
        return $this->value;
    }
}
