<?php

namespace App\Modules\BookingTour\Domain;

use DateTime;

class BookingTourDateStart {

    protected static $format = 'Y-m-d';
    private DateTime $value;

    public function __construct(DateTime | string $value) {
        if (is_string($value)) {
            $this->value = new DateTime($value);
        } else {
            $this->value = $value;
        }
    }

    public function getValue() { return $this->value; }

    public function value() {
        return $this->value->format(self::$format);
    }
}