<?php

namespace App\Modules\BookingTour\Application\UpdateGroup;

use App\Http\Controllers\Owner\Passenger\PassengerUpdater;
use App\Modules\Booking\Domain\IdBooking;
use App\Modules\BookingTour\Application\UpdateGroup\UpdateGroupBookingTourQueryResponse;
use App\Modules\BookingTour\Domain\BookingTourFeeType;
use App\Modules\BookingTour\Domain\BookingTourFull;
use App\Modules\BookingTour\Domain\BookingTourGroup;
use App\Modules\BookingTour\Domain\BookingTourPassengerListRepository;
use App\Modules\BookingTour\Domain\BookingTourRepository;
use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

final class BookingTourGroupUpdater
{
    public function __construct(
        private BookingTourRepository $repository,
        private BookingTourPassengerListRepository $passengerListRepository,
        private QueryBus $queryBus,
        private PassengerUpdater $passengerUpdater
    ) {}

    public function __invoke(
        IdBooking $idBooking,
        BookingTourGroup $group,
        BookingTourFeeType $feeType,
        BookingTourFull $full
    ) {
        $response = $this->repository->updateGroup($idBooking, $group, $feeType, $full);
        $bookingTourList = $this->repository->listByGroup($idBooking, $group);
        $idPassengers = [];

        foreach ($bookingTourList['Response_Data'] as $bt) {
            $btpList = $this->passengerListRepository->list(
                'all',
                new IdBookingTour($bt->Id_BookingTour),
                0,
                ''
            );

            $length = count($btpList);
            foreach ($btpList as $btp) {
                if (!in_array($btp->Id_Passenger, $idPassengers)) {
                    $idPassengers[] = $btp->Id_Passenger;
                }
                $this->passengerListRepository->updateFull(
                    new IdBookingTour($bt->Id_BookingTour),
                    new IdPassenger($btp->Id_Passenger),
                    $length
                );
            }
        }

        foreach ($idPassengers as $idPassenger) {
            $this->passengerUpdater->updateLockHtlCampBookingPassenger($idPassenger);
        }

        return new UpdateGroupBookingTourQueryResponse($response);
    }
}
